//
// Copyright [2009] Autodesk, Inc.  All rights reserved. 
//
// This computer source code and related instructions and comments are the
// unpublished confidential and proprietary information of Autodesk, Inc. and
// are protected under applicable copyright and trade secret law.  They may
// not be disclosed to, copied or used by any third party without the prior
// written consent of Autodesk, Inc.
//
//
// World-view-projection transformation.
float4x4 g_World : World;
float4x4 g_ViewProj : ViewProjection;
float4x4 g_WorldView : WorldView;
float4x4 g_ViewInv : ViewInverse;

struct ATTRIBUTE_VSOUT 
{
	float4 Pos : POSITION;
	float4 PosInView : TEXCOORD0;
	float4 NormInView : TEXCOORD1;
};

ATTRIBUTE_VSOUT Attribute_VS(float3 Pos  : POSITION, 
							 float3 col  : COLOR, 
							 float3 Norm : NORMAL) 
{
	ATTRIBUTE_VSOUT Out;
	float4 wPos = mul(float4(Pos,1), g_World);
	Out.Pos     = mul(wPos, g_ViewProj);
	Out.PosInView = mul(float4(Pos.xyz, 1.0f), g_WorldView);
	Out.NormInView = mul(float4(Norm, 0.0f), g_WorldView);
	return Out;
}


void Attribute_PS(float4 PosInView : TEXCOORD0,
				float3 NormInView : TEXCOORD1,
				float4 Pos : POSITION,
				out float4 MRT0 : COLOR0) 
{
	MRT0 = float4(normalize(NormInView), PosInView.z / PosInView.w);
}

// The main technique.
technique Main
{
    pass p0
    {
		ALPHATESTENABLE = FALSE;
        VertexShader = compile vs_3_0 Attribute_VS();
        PixelShader = compile ps_3_0 Attribute_PS();
    }
}

